Create table Users (
      u_user_id VarChar (20) Not Null,
      password VarChar (100) Not Null,
      role ENUM('tr1','tr2','admin') Not Null,
      real_name VARCHAR(255) Not Null,
      email VARCHAR(255) Not Null,
      note VARCHAR(255) Null,
      state ENUM('active','suspended','removed') Not Null,
      last_login TIMESTAMP,
      config4 Integer Null,
      config3 Integer Null,
      config1 Integer Null,
      config2 Integer Null,
      Constraint PK_User Primary Key (u_user_id)
);

Create table Languages (
      language_id VARCHAR(5) Not Null,
      language_name VARCHAR(255) CHARACTER SET utf8 Not Null,
      font1 VARCHAR(50) Null,
      font2 VARCHAR(50) Null,
      f_desc TEXT Null,
      Constraint PK_Language Primary Key (language_id)
);

Create table Versions (
      version_id Integer Not Null,
      v_name VARCHAR(50) Not Null,
      maintainer_user_id VarChar (20) Not Null,
      Constraint PK_Version Primary Key (version_id)
);

Create table Objects (
      obj_name VARCHAR(100) Not Null,
      Version_version_id Integer Not Null,
      obj VARCHAR(50) Not Null,
      image_path VarChar(255) Not Null,
      img_dsc TEXT Null,
      Constraint PK_Object Primary Key (obj_name, Version_version_id)
);

Create table Translations (
      Object_obj_name VARCHAR(100) Not Null,
      Object_Version_version_id Integer Not Null,
      language_language_id VARCHAR(5) Not Null,
      tr_text TEXT Null,
      suggestion TEXT Null,
      mod_date TIMESTAMP,
      reservator_user_id VarChar (20) Null,
      date_to DateTIME Null,
      author_user_id VarChar (20) Not Null,
      Constraint PK_Translation Primary Key (Object_obj_name, Object_Version_version_id, Language_language_id)
);


Create table Property (
      p_value VARCHAR (50) Not Null,
      p_name VARCHAR (50) Not Null,
      having_obj_name VARCHAR(100) Not Null,
      having_Version_version_id Integer Not Null,
      Constraint PK_Property Primary Key (p_name, having_obj_name, having_Version_version_id)
);

Create table Translate (
      lng_tr_language_id VARCHAR (5) Not Null,
      translator_user_id VarChar (20) Not Null,
      Constraint UNQ_Translates_1 Unique (lng_tr_language_id, translator_user_id)
);



Alter table Versions add (
      Constraint FK_Version_1 Foreign Key (maintainer_user_id) References Users(u_user_id)
);

Alter table Objects add (
      Constraint FK_Object_1 Foreign Key (Version_version_id) References Versions(version_id),

      INDEX (obj_name(10))
);

Alter table Property add (
      Constraint FK_Property_1 Foreign Key (having_obj_name, having_Version_version_id) References Objects (obj_name, Version_version_id)
);


Alter table Translations add (
      Constraint FK_Translation_1 Foreign Key (Object_obj_name, Object_Version_version_id) References Objects(obj_name, Version_version_id),
      Constraint FK_Translation_2 Foreign Key (language_language_id) References  Languages (language_id),

      Constraint FK_Reserved_2 Foreign Key (reservator_user_id) References Users(u_user_id),
      Constraint FK_Wrote_2 Foreign Key (author_user_id) References Users (u_user_id),

      INDEX (Object_obj_name(10))
);

Alter table Translate add (
      Constraint FK_Translates_1 Foreign Key (lng_tr_language_id) References Languages(language_id),
      Constraint FK_Translates_2 Foreign Key (translator_user_id) References Users(u_user_id)
);